# {{cookiecutter.deployment_name}} Application

This deployment was auto-generated by the F' utility tool.

## Building and Running the {{cookiecutter.deployment_name}} Application

In order to build the {{cookiecutter.deployment_name}} application, or any other F´ application, we first need to generate a build directory. This can be done with the following commands:

```
cd {{cookiecutter.deployment_name}}
fprime-util generate
```

The next step is to build the {{cookiecutter.deployment_name}} application's code.
```
fprime-util build
```

## Running the application and F' GDS

The following command will spin up the F' GDS as well as run the application binary and the components necessary for the GDS and application to communicate.

```
cd {{cookiecutter.deployment_name}}
fprime-gds
```

{% if cookiecutter.com_driver_type != "UART" %}
To run the ground system without starting the {{cookiecutter.deployment_name}} app:
```

cd {{cookiecutter.deployment_name}}
fprime-gds --no-app
```

The application binary may then be run independently from the created 'bin' directory.

```
cd {{cookiecutter.deployment_name}}/build-artifacts/<platform>/bin/
./{{cookiecutter.deployment_name}} -a 127.0.0.1 -p 50000
```
{% endif %}

## This deployment uses F' **core subtopologies** for a modular, reusable architecture:

- **CdhCore**: Command & Data Handling
  - Command dispatching and event management
  - Event logging and telemetry collection  
  - Health monitoring system
  - Fatal error handling

- **ComCcsds**: CCSDS Communication Subsystem
  - CCSDS protocol implementation
  - Uplink/downlink data handling
  - Frame processing and routing

- **FileHandling**: File Transfer & Command Sequencing
  - File upload and download services
  - Parameter database management
  - File system operations

- **DataProducts**: Data Product Management
  - Data product cataloging
  - Storage and retrieval capabilities
  - Product metadata management